﻿using System;
using System.Collections.Generic;
using System.Linq.Expressions;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.TwitchApi;

namespace Curse.Friends.TwitchService
{
    public class TwitchBadgeDescriptor
    {
        public string BadgeSet { get; set; }
        public string Version { get;set; }
        public string Title { get; set; }
        public string Description { get; set; }
        public string ImageUrl { get; set; }
        public string ClickUrl { get; set; }
        public string ClickAction { get; set; }

        public static TwitchBadgeDescriptor[] GetDescriptors(GlobalChatBadgesResponse badgeResponse)
        {
            if (badgeResponse.BadgeSets == null)
            {
                return new TwitchBadgeDescriptor[0];
            }

            var descriptors = new List<TwitchBadgeDescriptor>();
            foreach (var set in badgeResponse.BadgeSets)
            {
                foreach (var version in set.Value.Versions)
                {
                    descriptors.Add(new TwitchBadgeDescriptor
                    {
                        BadgeSet = set.Key,
                        Version = version.Key,
                        Title = version.Value.Title,
                        Description = version.Value.Description,
                        ImageUrl = version.Value.ImageUrl1x,
                        ClickUrl = version.Value.ClickUrl,
                        ClickAction = version.Value.ClickAction,
                    });
                }
            }
            return descriptors.ToArray();
        }

        public void UpdateModel(TwitchChatBadge badge, string externalID = null, Avatar avatar = null)
        {
            if (badge != null)
            {
                var changes = new List<Expression<Func<TwitchChatBadge, object>>>();
                if (badge.IsDeleted || badge.Title != Title || badge.Description != Description || badge.ImageUrl != ImageUrl)
                {
                    badge.IsDeleted = false;
                    changes.Add(e => e.IsDeleted);
                }
                if (badge.Title != Title)
                {
                    badge.Title = Title;
                    changes.Add(e => e.Title);
                }
                if (badge.Description != Description)
                {
                    badge.Description = Description;
                    changes.Add(e => e.Description);
                }
                if (badge.ClickAction != ClickAction)
                {
                    badge.ClickAction = ClickAction;
                    changes.Add(e => e.ClickAction);
                }
                if (badge.ClickUrl != ClickUrl)
                {
                    badge.ClickUrl = ClickUrl;
                    changes.Add(e => e.ClickUrl);
                }
                if (badge.ImageUrl != ImageUrl)
                {
                    badge.ImageUrl = ImageUrl;
                    changes.Add(e => e.ImageUrl);
                }
                if (changes.Count > 0)
                {
                    badge.Update(changes.ToArray());
                }
            }
            else
            {
                badge = new TwitchChatBadge
                {
                    BadgeSet = BadgeSet,
                    Version = Version,
                    ExternalID = externalID ?? TwitchChatBadge.GlobalExternalID,
                    Title = Title,
                    Description = Description,
                    ImageUrl = ImageUrl,
                    ClickUrl = ClickUrl,
                    ClickAction = ClickAction,
                    IsDeleted = false,
                };
                badge.InsertLocal();
            }

            var entityID = TwitchChatBadge.GetAvatarEntityID(BadgeSet, Version, externalID);
            var url = ImageUrl;

            var existing = avatar ?? Avatar.GetByTypeAndID(AvatarType.TwitchChatBadge, entityID);
            if (existing == null || existing.Url != url)
            {
                AvatarUpdatePump.UpdateAvatar(AvatarType.TwitchChatBadge, entityID, url);
            }
        }
    }
}
