﻿using System;
using System.Linq;
using System.Runtime.Caching;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.TwitchApi;

namespace Curse.Friends.TwitchService
{
    public class TwitchCaching
    {
        private static readonly MemoryCache _userIDsByTwitchIDs = new MemoryCache("UserIDsByTwitchIDs");
        private static readonly MemoryCache _externalCommunitiesByChannelNames = new MemoryCache("ExternalCommunitesByChannelNames");

        public static int[] GetMappedUserIDsByTwitchID(long twitchID)
        {
            if (twitchID == 0)
            {
                return new int[0];
            }

            var externalID = twitchID.ToString();

            var existing = _userIDsByTwitchIDs.Get(externalID);
            if (existing == null)
            {
                var acct = ExternalAccount.GetLocal(externalID, AccountType.Twitch);
                var value = acct == null || acct.MappedUsers == null ? new int[0] : acct.MappedUsers.ToArray();
                existing = _userIDsByTwitchIDs.AddOrGetExisting(twitchID.ToString(), value, DateTimeOffset.UtcNow.AddMinutes(5)) ?? value;
            }

            return existing as int[];
        }

        public static ExternalCommunity GetExternalCommunityByChannelName(string channelName)
        {
            if (string.IsNullOrEmpty(channelName))
            {
                return null;
            }

            var existing = _externalCommunitiesByChannelNames.Get(channelName);
            if (existing == null)
            {
                var resp = TwitchApiHelper.Default.GetChannelV3(channelName);
                if (resp.Status != TwitchResponseStatus.Success)
                {
                    return null;
                }
                var community = ExternalCommunity.GetLocal(resp.Value.ID, AccountType.Twitch);
                if (community == null)
                {
                    return null;
                }

                existing = _externalCommunitiesByChannelNames.AddOrGetExisting(channelName, community, DateTimeOffset.UtcNow.AddMinutes(15)) ?? community;
            }

            return existing as ExternalCommunity;
        }
    }
}
