﻿using Curse.Friends.Configuration;
using Curse.Friends.ServerHosting;
using Curse.Friends.TwitchService.Configuration;

namespace Curse.Friends.TwitchService
{
    public partial class TwitchService : CurseWindowsService
    {
        public TwitchService()
        {
            ServiceName = "TwitchService";
        }

        protected override ServiceHostType HostType
        {
            get { return ServiceHostType.TwitchService; }
        }

        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.All; }
        }

        protected override void CustomStartup()
        {
            TwitchServer.StartServer();
        }

        protected override void CustomStop()
        {
            TwitchServer.StopServer();
        }
    }
}
