﻿using Curse.Friends.Data;
using Curse.Friends.Data.Messaging;
using Microsoft.CSharp.RuntimeBinder;
using Newtonsoft.Json;

namespace Curse.Friends.UserEvents
{

    public abstract class BaseUserEvent
    {
        public int UserID { get; set; }

        public UserStatistics GetUserStatistics()
        {
            return UserStatistics.GetByUserID(UserID);
        }

        public User GetUser()
        {
            return User.FindByUserID(UserID);
        }

        public bool IsUserMerged()
        {
            // TODO: Replace with just a GetUser()?.IsMerged when User global is turned on
            var stats = GetUserStatistics();
            if (string.IsNullOrEmpty(stats?.TwitchID))
            {
                return false;
            }

            return ExternalAccount.GetByTwitchUserID(stats.TwitchID)?.MergedUserID == UserID;
        }

        public void Enqueue()
        {
            new UserEventWorker
            {
                EventType = GetType().Name,
                EventData = JsonConvert.SerializeObject(this)
            }.Enqueue();
        }

        public object GetLogData()
        {
            var obj = MemberwiseClone() as dynamic;
            try
            {
                obj.MessageBody = "<redacted>";
            }
            catch { }

            return obj;
        }
    }



    public class UserPair
    {
        public UserStatistics User { get; set; }
        public UserStatistics OtherUser { get; set; }

        public bool HaveTwitchIDs
        {
            get { return User != null && User.HasTwitchID && OtherUser != null && OtherUser.HasTwitchID; }
        }

        public string[] ParticipantTwitchIDs
        {
            get { return new[] { User.TwitchID, OtherUser.TwitchID }; }
        }

        public bool BothParticipantsMerged
        {
            get
            {
                return HaveTwitchIDs && ExternalAccount.GetByTwitchUserID(User.TwitchID)?.MergedUserID == User.UserID &&
                       ExternalAccount.GetByTwitchUserID(OtherUser.TwitchID)?.MergedUserID == OtherUser.UserID;
            }
        }
    }

    public class BaseUserPairEvent : BaseUserEvent
    {
        public int OtherUserID { get; set; }

        public UserPair GetUserPair()
        {
            return new UserPair
            {
                User = UserStatistics.GetByUserID(UserID),
                OtherUser = UserStatistics.GetByUserID(OtherUserID)
            };
        }
    }

    public abstract class BaseConversationUserEvent : BaseUserEvent
    {
        public string ConversationID { get; set; }

        public int GetRecipientID()
        {
            return ConversationManager.GetFriendID(UserID, ConversationID);
        }

        public UserPair GetSenderAndRecipient()
        {
            var recipientID = GetRecipientID();

            return new UserPair
            {
                User = UserStatistics.GetByUserID(UserID),
                OtherUser = UserStatistics.GetByUserID(recipientID)
            };
        }
    }
}
