﻿using Curse.Friends.Data;
using Curse.Friends.Enums;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Curse.Friends.WebService.Tests.Clans
{
    public static class GroupMessagingTests
    {
        [TestClass]
        public class SendClanRootMessage : ClansContext
        {
            private static Group _clanRoot;

            [ClassInitialize]
            public static void Initialize(TestContext context)
            {
                try
                {
                    _clanRoot = CreateRootGroup("SendClanRootMessage Test Clan", GroupType.Large);
                    SendGroupMessage(_clanRoot, "SendClanRootMessage Test Message");
                }
                catch
                {
                    CleanUp();
                    throw;
                }
            }


            [TestMethod]
            public void Does_Not_Persist_Conversation()
            {
                Assert.IsNull(Conversation.GetByTypeAndID(ConversationType.Group, _clanRoot.GroupID.ToString()));
            }

            [ClassCleanup]
            public static void CleanUp()
            {
                var conversation = Conversation.GetByTypeAndID(ConversationType.Group, _clanRoot.GroupID.ToString());
                if (conversation != null)
                {
                    conversation.Delete();
                }

                CleanUpDatabase(_clanRoot);
            }
        }

        [TestClass]
        public class SendTemporaryChannelMessage : ClansContext
        {
            private static Group _clanRoot;
            private static Group _tempGroup;

            [ClassInitialize]
            public static void Initialize(TestContext context)
            {
                try
                {
                    _clanRoot = CreateRootGroup("SendTemporaryChannelMessage Test Clan", GroupType.Large);
                    _clanRoot.AllowTempChannels = true;
                    _clanRoot.Update(p => p.AllowTempChannels);

                    _tempGroup = AddSubChannel(_clanRoot, "SendTemporaryChannelMessage Test Channel", Creator,
                        LegacyGroupRole.Member, GroupType.Temporary);
                    SendGroupMessage(_tempGroup, "SendTemporaryChannelMessage Test Message");
                }
                catch
                {
                    CleanUp();
                    throw;
                }
            }

            [TestMethod]
            public void Does_Not_Persist_Conversation()
            {
                Assert.IsNull(Conversation.GetByTypeAndID(ConversationType.Group, _tempGroup.GroupID.ToString()));
            }


            [ClassCleanup]
            public static void CleanUp()
            {
                if (_tempGroup != null)
                {
                    var conversation = Conversation.GetByTypeAndID(ConversationType.Group, _tempGroup.GroupID.ToString());
                    if (conversation != null)
                    {
                        conversation.Delete();
                    }
                }

                CleanUpDatabase(_clanRoot);
            }
        }

        [TestClass]
        public class SendPermanentSubchannelMessage : ClansContext
        {
            private static Group _clanRoot;
            private static Group _subChannel;

            [ClassInitialize]
            public static void Initialize(TestContext context)
            {
                try
                {
                    _clanRoot = CreateRootGroup("SendPermanentSubchannelMessage Test Clan", GroupType.Large);
                    _subChannel = AddSubChannel(_clanRoot, "SendPermanentSubchannelMessage Test Channel");
                    SendGroupMessage(_subChannel, "SendPermanentSubchannelMessage Test Message");
                }
                catch
                {
                    CleanUp();
                    throw;
                }
            }

            [TestMethod]
            public void Persists_Conversation()
            {
                Assert.IsNotNull(Conversation.GetByTypeAndID(ConversationType.Group, _subChannel.GroupID.ToString()));
            }

            [ClassCleanup]
            public static void CleanUp()
            {
                if (_subChannel != null)
                {
                    var conversation = Conversation.GetByTypeAndID(ConversationType.Group,
                        _subChannel.GroupID.ToString());
                    if (conversation != null)
                    {
                        conversation.Delete();
                    }
                }

                CleanUpDatabase(_clanRoot);
            }
        }
    }
}
