﻿
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Curse.Friends.WebService.Tests.Clans
{   
    //THIS TEST FAILS EVERYTIME. IT SHOULD BE RUN BY CHANGING VALUES IN GROUP SERVER.
    public static class TemporaryChannelTests
    {
        [TestClass]
        public class TestIdleTemporaryGroup : ClansContext
        {
            private static Group _clanRoot;
            private static Group _tempChannel;

            [ClassInitialize]
            public static void Initialize(TestContext context )
            {
                _clanRoot = CreateRootGroup("Test Idle Temporary channel", GroupType.Large);
                ChangeInfo(_clanRoot, Creator.UserID, _clanRoot.Title, _clanRoot.AvatarUrl, _clanRoot.MessageOfTheDay,
                    true, null);
                _tempChannel = AddSubChannel(_clanRoot, "idle temporary channel", Admin, GroupRole.Member,
                    GroupType.Temporary);
            }

            [ClassCleanup]
            public static void Cleanup()
            {
                DeleteRootGroup(_clanRoot, Creator.UserID);
            }

            [TestMethod]
            public void CheckIdleTemporaryGroupExist()
            {
                var tempChannel = Group.GetLocal(_tempChannel.GroupID);
                Assert.IsNull(tempChannel, "This test fails everytime. It should be run by changing values in Group server");
            }

            [TestMethod]
            public void CheckGroupMemberlistForIdleTempGroup()
            {
                var memberlist = GroupMemberList.GetAllLocal(p => p.GroupID, _tempChannel.GroupID);
                Assert.IsNull(memberlist, "This test fails everytime. It should be run by changing values in Group server");
            }
        }
    }
}
