﻿using System;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.WebService.Tests.Utilities;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Curse.Friends.WebService.Tests.Friends
{
    public abstract class FriendContext
    {
        private const int MaxUserID = Int32.MaxValue - 10;
        private const int MaxAttempts = 20;

        /// <summary>
        /// Create a user that currently does not exist in database
        /// adds userregion to database
        /// </summary>
        /// <returns></returns>
        public static TestUser CreateUserandUserRegion(int regionID, string username, int? previuosUserID = null)
        {
            var userID = previuosUserID ?? MaxUserID;
            --userID;
            var user = User.Get(regionID, MaxUserID);
            var attempts = 0;
            while (user != null && attempts < MaxAttempts)
            {
                --userID;
                ++attempts;
                user = User.Get(1, userID);
            }
            if (attempts >= MaxAttempts)
            {
                throw new Exception("cannot create new user.");
            }
            user = new User(){UserID = userID, Username = username, ConnectionStatus = UserConnectionStatus.Online, FriendCount = 0};
            user.InsertLocal();
            var userRegion = new UserRegion() {UserID = user.UserID, RegionID = regionID};
            userRegion.InsertLocal();
            return new TestUser(){UserID = user.UserID, RegionID = regionID, Username = user.Username};
        }

        protected static void CleanupFriendsDatabase(params TestUser[] users)
        {
            foreach (var user in users)
            {
                if (user != null)
                {
                    user.Delete();
                    //delete any friendships with this user
                    var friendships = Friendship.GetAll(user.RegionID, p => p.UserID, user.UserID);
                    foreach (var friendship in friendships)
                    {
                        friendship.Delete();
                    }
                }
            }
        }

        protected static void CleanupFriendshipDatabase(params Friendship[] friendships)
        {
            foreach (var friendship in friendships)
            {
                if (friendship != null)
                {
                    friendship.Delete();
                }
            }
        }

        protected static Tuple<Friendship, Friendship> CreateFriendship(User user1, UserRegion region1, User user2, UserRegion region2, string message)
        {
            Friendship.CreateRequest(user1, region1, user2, region2,
                        null, message, false);
            var friendship1 = Friendship.Get(region1.RegionID, user1.UserID, user2.UserID);
            Assert.IsNotNull(friendship1);
            var friendship2 = Friendship.Get(region2.RegionID, user2.UserID, user1.UserID);
            Assert.IsNotNull(friendship2);
            return new Tuple<Friendship, Friendship>(friendship1, friendship2);
        }

        protected void CheckFriendshipStatus(TestUser me, int otherUserID, FriendshipStatus expectedStatus)
        {
            var friendship = Friendship.Get(me.RegionID, me.UserID, otherUserID);
            Assert.IsNotNull(friendship, "expected friendship should not be null");
            Assert.AreEqual(friendship.Status, expectedStatus);
        }
    }
}
