﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Curse.Friends.WebService.Tests.Groups.Normal
{
    public static class UserManagementTests
    {
        [TestClass]
        public class ChangeNotificationPreferences : GroupsContext
        {
            private static Group _group;
            private const NotificationPreference NewPreference = NotificationPreference.Disabled;

            [ClassInitialize]
            public static void Init(TestContext context)
            {
                try
                {
                    _group = CreateRootGroup("ChangeNotificationPreferences Normal Group", GroupType.Normal);
                    var adminMembership = GroupMembership.GetByUserAndGroupID(new UserRegion() { UserID = Admin.UserID, RegionID = Admin.RegionID }, _group.GroupID);
                    adminMembership.UpdateUserPreference(NewPreference, null);
                }
                catch
                {
                    CleanUp();
                    throw;
                }
            }

            [TestMethod]
            public void TestDisablePreferenceNormalGroup()
            {
                Assert.AreEqual(NewPreference,
                    GroupMembership.GetByUserAndGroupID(Admin.RegionID, Admin.UserID, _group.GroupID)
                        .NotificationPreference);
            }

            [ClassCleanup]
            public static void CleanUp()
            {
                CleanUpDatabase(_group);
            }
        }
    }
}
