﻿using System;
using System.Collections.ObjectModel;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using Curse.Logging;
using System.Web;
using System.ServiceModel.Web;

namespace Curse.Friends.WebService
{

    [AttributeUsage(AttributeTargets.Class)]
    public class FriendsServiceErrorHandler : Attribute, IServiceBehavior, IErrorHandler
    {
        protected Type ServiceType { get; set; }

        public void Validate(ServiceDescription serviceDescription, ServiceHostBase serviceHostBase)
        {
            
        }

        public void AddBindingParameters(ServiceDescription serviceDescription, ServiceHostBase serviceHostBase, Collection<ServiceEndpoint> endpoints,
            BindingParameterCollection bindingParameters)
        {
            
        }

        void IServiceBehavior.ApplyDispatchBehavior(ServiceDescription description, ServiceHostBase host)
        {
            ServiceType = description.ServiceType;
            foreach (ChannelDispatcher dispatcher in host.ChannelDispatchers)
            {
                dispatcher.ErrorHandlers.Add(this);
            }
        }

        public void ProvideFault(Exception error, MessageVersion version, ref Message fault)
        {

        }

        private string GetCurrentUrl()
        {
            try
            {
                if (HttpContext.Current != null)
                {
                    return HttpContext.Current.Request.Url.ToString();
                }
                else if (WebOperationContext.Current != null)
                {
                    return WebOperationContext.Current.IncomingRequest.UriTemplateMatch.RequestUri.ToString();
                }
                else
                {
                    return OperationContext.Current.RequestContext.RequestMessage.Headers.To.OriginalString;
                }
            }
            catch
            {
                return "Unknown";
            }            
        }

        public bool HandleError(Exception error)
        {
            var url = GetCurrentUrl();
            if (error == null)
            {
                return false;
            }

            if (error is FaultException)
            {
                return false;
            }

            if (error is HttpException)
            {
                return false;
            }

            Logger.Warn(error, "General Service Error: " + url);
            return false;
        }
    }
}