﻿using System;
using System.Web;
using Curse.Logging;
using System.Threading;
using Curse.Friends.Configuration;

namespace Curse.Friends.WebService
{
    public class Global : System.Web.HttpApplication
    {
        protected static DomainWhitelist _corsWhitelist;

        protected void Application_Start(object sender, EventArgs e)
        {
            FriendsService.Startup();
            _corsWhitelist = new DomainWhitelist(FriendsServiceConfiguration.Instance.CrossDomainWhitelist);
        }
        
        protected void Application_End(object sender, EventArgs e)
        {
            FriendsService.Shutdown();
        }

        private static void WriteCors(HttpRequest req, HttpResponse res)
        {
            var origin = req.Headers["Origin"];
            if (!string.IsNullOrWhiteSpace(origin))
            {
                if (_corsWhitelist.IsWhiteListed(origin, true))
                {
                    res.Headers["Access-Control-Allow-Origin"] = origin;
                    res.Headers["Access-Control-Allow-Credentials"] = "true";
                }
            }
        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {
            var request = HttpContext.Current.Request;
            var response = HttpContext.Current.Response;

            WriteCors(request, response);

            if (HttpContext.Current.Request.HttpMethod == "OPTIONS")
            {
                response.StatusCode = 200;
                //These headers are handling the "pre-flight" OPTIONS call sent by the browser
                response.AddHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
                response.AddHeader("Access-Control-Allow-Headers", "Content-Type, Accept, AuthenticationToken");
                response.AddHeader("Access-Control-Max-Age", "1728000");
                response.End();
            }
        }

        protected void Application_Error(object sender, EventArgs e)
        {            
            try
            {
                // Get the exception object.
                var ex = Server.GetLastError();

                if (ex == null || ex is ThreadAbortException)
                {
                    return;
                }
                
                Logger.Error(ex, "General Server Error: " + HttpContext.Current.Request.Url);
            }
            catch { } // Ensure that nothing in here generated another exception, no matter what!
            
        }
    }
}