﻿using System;
using Curse.CloudServices.Authentication;
using Curse.Friends.WebService.Requests;
using Curse.Friends.WebService.Responses;
using System.Net.Security;
using System.ServiceModel;
using System.ServiceModel.Web;

namespace Curse.Friends.WebService
{    
    [ServiceContract(Namespace = "http://friends.cursevoice.com/", ProtectionLevel = ProtectionLevel.None)]
    public interface IFriendsService
    {

        [OperationContract]
        [RequiresAuthentication(AccessLevel.ApiKey)]
        AddFriendHintResponse AddFriendHint(FriendHintRequest hint);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        FriendSearchResponse FindFriends(FriendSearchRequest hint);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebGet]
        GetSelfHintsResponse GetSelfHints();

        [Obsolete]
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebGet]
        GetMyFriendsResponse GetMyFriends();

        [OperationContract]
        [WebGet]
        GetMyFriendSuggestionsResponse GetMyFriendSuggestions();

        [OperationContract]
        [WebInvoke]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        GetFriendsOfFriendResponse GetFriendsOfFriend(int friendID);

        [OperationContract]
        [WebGet]
        GetMyPushNotificationPreferencesResponse GetMyPushNotificationPreferences();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        RequestFriendshipResponse RequestFriendship(FriendshipRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        ToggleFavoriteResponse ToggleFavorite(ToggleFavoriteRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        RenameFriendResponse RenameFriend(RenameFriendRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        ConfirmFriendshipResponse ConfirmFriendship(ConfirmFriendshipRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        DeclineFriendshipResponse DeclineFriendship(DeclineFriendshipRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]        
        RegisterSelfResponse RegisterSelf(RegisterSelfRequest request);

        [OperationContract]
        [WebInvoke]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse UpdateDeviceTokens(UpdateDeviceTokensRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse UnregisterEndpoint(UnregisterEndpointRequest request);
        
        [OperationContract]
        [WebGet]
        [Obsolete]
        GetHostListResponse GetHostList();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        ChangeStatusResponse ChangeStatus(ChangeStatusRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        ChangeGameStatusResponse ChangeGameStatus(ChangeGameStatusRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse RemoveFriendship(RemoveFriendshipRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse UnblockFriendship(UnblockFriendshipRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse ChangeFriendNotificationPreferences(ChangeFriendNotificationPreferencesRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        ChangeProfileResponse ChangeProfile(ChangeProfileRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse DeclineFriendSuggestion(DeclineFriendSuggestionRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse UploadFriendHints(string payload);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse FriendListSearch(FriendListSearchRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        UserProfileResponse GetUserProfile(int userID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.WrappedRequest)]
        UserProfileResponse GetUserInfo(int userID, string apiKey);

        [OperationContract]
        [WebGet(UriTemplate = "health-check")]
        string HealthCheck();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse ChangePushNotificationPreferences(ChangePushNotificationPreferencesRequest request);
                
        #region Group API

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        CreateGroupResponse CreateGroup(CreateGroupRequest request);

        [Obsolete]
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebGet]
        GetMyGroupsResponse GetMyGroups();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse RenameGroup(ChangeGroupRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse ChangeGroupInfo(ChangeGroupRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse AddUsersToGroup(AddUserToGroupRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse RemoveUsersFromGroup(RemoveUsersFromGroupRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse LeaveGroup(LeaveGroupRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse ToggleFavoriteGroup(FavoriteGroupRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        GetGroupDetailsResponse GetGroupDetails(GroupDetailsRequest request);        
        
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse ChangeGroupNotificationPreferences(ChangeGroupNotificationPreferencesRequest request);


        #endregion

        #region Voice Calls
        
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        VoiceSessionResponse CallGroup(CallGroupRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        VoiceSessionResponse CallFriend(CallFriendRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse UnlockCall(UnlockCallRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicServiceResponse AddFriendToCall(AddFriendToCallRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        RespondToCallResponse RespondToCall(RespondToCallRequest request);

        #endregion       
    }    
   
}
