﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Web;
using System.Web;

namespace Curse.Friends.WebService
{
    public static class IPAddressExtensions
    {       
        /// <summary>
        /// Returns the IP address of the connected WCF client.
        /// </summary>
        /// <param name="operationContext"></param>
        /// <param name="silentFailure"></param>
        /// <returns></returns>
        public static IPAddress GetClientIPAddress(this OperationContext operationContext, bool silentFailure = true)
        {

            if (WebOperationContext.Current == null)
            {
                return GetClientIPAddress(GetOperationContextIPAddress(operationContext));
            }

            return GetClientIPAddress(WebOperationContext.Current.IncomingRequest.Headers["X-Forwarded-For"] ?? GetOperationContextIPAddress(operationContext) ?? string.Empty, silentFailure);
        }

        private static string GetOperationContextIPAddress(OperationContext context)
        {
            var prop = context.IncomingMessageProperties;
            var endpoint = prop[RemoteEndpointMessageProperty.Name] as RemoteEndpointMessageProperty;

            if (endpoint != null)
            {
                return endpoint.Address;
            }
            return null;
        }

        private static IPAddress GetClientIPAddress(string ipString, bool silentFailure = true)
        {
            if (ipString.Contains(","))
            {
                var ipArray = ipString.Split(',');
                ipString = ipArray[ipArray.Length - 1].Trim();
            }

            IPAddress ipAddress;
            if (IPAddress.TryParse(ipString, out ipAddress))
            {
                var family = ipAddress.AddressFamily;
                if (family == AddressFamily.InterNetwork || family == AddressFamily.InterNetworkV6)
                {
                    var bytes = ipAddress.GetAddressBytes();
                    if (bytes != null && bytes.Length > 0)
                    {
                        return ipAddress;
                    }
                }
            }
            if (silentFailure)
            {
                return IPAddress.None;
            }
            else
            {
                throw new InvalidOperationException(string.Format("Cannot parse IPAddress '{0}'", ipString));
            }
        }
    }
}