﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Extensions;

namespace Curse.Friends.WebService.Requests
{
    public class AddEmoticonRequest : BaseRequestContract
    {
        public Guid GroupID { get; set; }

        public string Regex { get; set; }

        public string Url { get; set; }

        public HashSet<int> RequiredRoles { get; set; }

        public override bool Validate()
        {
            return GroupID != Guid.Empty && !string.IsNullOrWhiteSpace(Regex) && !string.IsNullOrWhiteSpace(Url);
        }
    }
}