﻿namespace Curse.Friends.WebService.Requests
{
    public class AddFriendToCallRequest : BaseRequestContract
    {
        public string CallCode { get; set; }

        public int FriendID { get; set; }

        public override bool Validate()
        {
            if (CallCode == null)
            {
                _validationMessage = "Call code was not specified.";
                return false;
            }
            if (FriendID <= 0)
            {
                _validationMessage = "Specified friend is invalid.";
                return false;
            }

            return true;
        }
    }
}