﻿using System;
using System.Collections.Generic;
using Curse.Friends.Data;
using System.Linq;
using System.Web;

namespace Curse.Friends.WebService.Requests
{
    public class AddUserToGroupRequest : BaseRequestContract
    {
        public Guid GroupID
        {
            get;
            set;
        }

        public HashSet<int> UserIDs
        {
            get;
            set;
        }

        public override bool Validate()
        {
            if (GroupID == Guid.Empty)
            {
                _validationMessage = "Group is not specified";
                return false;
            }

            if (UserIDs == null)
            {
                _validationMessage = "Invalid receipients";
                return false;
            }

            if (UserIDs.Count > Group.MaxUsersInGroup)
            {
                _validationMessage = "Too many users!";
                return false;
            }
            return true;
        }
    }
}