﻿using System;

namespace Curse.Friends.WebService.Requests
{
    public class CallFriendRequest : BaseRequestContract
    {
        public int FriendID { get; set; }
        public string ClientVersion { get; set; }
        public bool Force { get; set; }
        public bool SendInvitation { get; set; }

        public override bool Validate()
        {
            if (FriendID <= 0)
            {
                _validationMessage = "Friend was not specified.";
                return false;
            }

            Version throwaway;
            if (ClientVersion == null || !Version.TryParse(ClientVersion, out throwaway))
            {
                _validationMessage = "client version is not valid.";
                return false;
            }

            return true;
        }
    }
}