﻿using System;
using Curse.Friends.Data;

namespace Curse.Friends.WebService.Requests
{
    public class CallGroupRequest : BaseRequestContract
    {
        public Guid GroupID { get; set; }
        public string ClientVersion { get; set; }
        public bool Force { get; set; }
        public bool SendInvitation { get; set; }
        public int[] TargetUserIDs { get; set; }

        public override bool Validate()
        {
            if (GroupID == Guid.Empty)
            {
                _validationMessage = "group was not specified.";
                return false;
            }

            if (TargetUserIDs != null && TargetUserIDs.Length > Group.MaxUsersInGroup)
            {
                _validationMessage = "TargetUserIDs contains more than the maximum allowed";
                return false;
            }

            Version throwaway;
            if (ClientVersion == null || !Version.TryParse(ClientVersion, out throwaway))
            {
                _validationMessage = "client version is not valid.";
                return false;
            }

            return true;
        }
    }
}