﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.Friends.Data;
using Curse.Friends.Enums;

namespace Curse.Friends.WebService.Requests
{
    public class ChangeFriendNotificationPreferencesRequest : BaseRequestContract
    {
        public int FriendID { get; set; }

        public NotificationPreference Preference { get; set; }

        public HashSet<String> FilterSet { get; set; }

        public override bool Validate()
        {
            if (FriendID <= 0)
            {
                _validationMessage = "FriendID ID is null or empty";
                return false;
            }

            if ((Preference < NotificationPreference.Enabled) || (Preference > NotificationPreference.Filtered))
            {
                _validationMessage = "Invalid preference value";
                return false;
            }
            if (FilterSet != null &&
                (FilterSet.Count > Group.MaxNumberFilterWords || FilterSet.Aggregate(0, (count, fw) => count + fw.Length) > Group.MaxTotalFilterLength))
            {
                _validationMessage = "Too many filter words or the total length of the filter words is too long";
                return false;
            }

            return true;
        }
    }
}