﻿using Curse.Friends.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Friends.WebService.Requests
{
    public class ChangeGameStatusRequest : BaseRequestContract
    {
        public int? GameID
        {
            get;
            set;
        }

        public int GameState
        {
            get;
            set;
        }

        public string GameStatusMessage
        {
            get;
            set;
        }

        public bool IsRunning
        {
            get;
            set;
        }

        public string MachineKey
        {
            get; 
            set;
        }
        
        public override bool Validate()
        {
            if (GameStatusMessage != null && GameStatusMessage.Length > User.CurrentGameStatusMessageMaxLength)
            {
                _validationMessage = "Game status cannot exceed " + User.CurrentGameStatusMessageMaxLength + " characters";
                return false;
            }

            return true;
        }
    }
}