﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Friends.Enums;

namespace Curse.Friends.WebService.Requests
{
    public class ChangeGroupPermissionsRequest : BaseRequestContract
    {
        public Guid GroupID { get; set; }

        public Dictionary<GroupPermissions, int> PermissionsChanges { get; set; } 

        public override bool Validate()
        {
            if (GroupID == Guid.Empty)
            {
                _validationMessage = "Group was not specified.";
                return false;
            }

            if (PermissionsChanges == null || PermissionsChanges.Count < 1)
            {
                _validationMessage = "no permission changes were specified.";
                return false;
            }

            return true;
        }
    }
}