﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Extensions;
using Curse.Friends.Data;

namespace Curse.Friends.WebService.Requests
{
    public class ChangeGroupRequest : BaseRequestContract
    {
        public Guid GroupID { get; set; }
        public string Title { get; set; }
        public string AvatarUrl { get; set; }
        public string MessageOfTheDay { get; set; }
        public bool? AllowTemporaryChildGroups { get; set; }
        public bool? ForcePushToTalk { get; set; }

        public override bool Validate()
        {
            if (GroupID == Guid.Empty)
            {
                _validationMessage = "Group is null";
                return false;
            }

            if (Title.SafeLength() > Group.TitleMaxLength)
            {
                _validationMessage = "Title is too long!";
                return false;
            }

            if (AvatarUrl.SafeLength() > Group.AvatarMaxLength)
            {
                _validationMessage = "Avatar URL is too long";
                return false;
            }

            if (MessageOfTheDay.SafeLength() > Group.MessageOfTheDayMaxLength)
            {
                _validationMessage = "Message of the Day is too long.";
                return false;
            }

            return true;
        }
    }
}