﻿using System;
using Curse.Friends.Enums;

namespace Curse.Friends.WebService.Requests
{
    public class ChangeGroupUserRoleRequest : BaseRequestContract
    {
        public int UserID { get; set; }
        public Guid GroupID { get; set; }
        public int RoleID { get; set; }
        
        public override bool Validate()
        {
            if (GroupID == Guid.Empty)
            {
                _validationMessage = "group was not specified.";
                return false;
            }

            if (UserID <= 0)
            {
                _validationMessage = "user was not specified.";
                return false;
            }

            if (RoleID <= 0)
            {
                _validationMessage = "user was not specified.";
                return false;
            }
           
            return true;
        }
    }
}