﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Friends.Enums;
using Curse.Friends.Data;

namespace Curse.Friends.WebService.Requests
{
    public class ChangeStatusRequest : BaseRequestContract
    {
        public Guid MachineKey
        {
            get;
            set;
        }

        public UserConnectionStatus Status
        {
            get;
            set;
        }

        public string CustomStatusMessage
        {
            get;
            set;
        
        }

        public override bool Validate()
        {
            if (Status == UserConnectionStatus.Offline)
            {
                _validationMessage = "User cannot change their status to offline manually.";
                return false;
            }

            if (MachineKey == null || MachineKey == Guid.Empty)
            {
                _validationMessage = "MachineKey must be a valid Guid";
                return false;
            }

            if (CustomStatusMessage != null && CustomStatusMessage.Length > Friendship.CustomStatusMaxLength)
            {
                _validationMessage = "Custom status messages cannot exceed " + CustomStatusMessage.Length + " characters";
                return false;
            }

            return true;
        }
    }
}