﻿namespace Curse.Friends.WebService.Requests
{

    public class ConversationDeleteAttachmentRequest : BaseRequestContract
    {
        public string ConversationID { get; set; }
        public string MessageID { get; set; }
        public long MessageTimestamp { get; set; }
        public string AttachmentID { get; set; }
    
        public override bool Validate()
        {
            if (string.IsNullOrEmpty(ConversationID))
            {
                return false;
            }

            if (string.IsNullOrEmpty(AttachmentID))
            {
                return false;
            }

            if (string.IsNullOrEmpty(MessageID))
            {
                return false;
            }

            if (MessageTimestamp <= 0)
            {
                return false;
            }

            return true;
        }
    }
}