﻿using Curse.Extensions;
using Curse.Friends.Data;

namespace Curse.Friends.WebService.Requests
{
    public class ConversationEditMessageRequest : BaseRequestContract
    {
        public string ConversationID { get; set; }
        public string MessageID { get; set; }
        public long MessageTimestamp { get; set; }
        public string Body { get; set; }

        public override bool Validate()
        {
            if (string.IsNullOrEmpty(ConversationID))
            {
                return false;
            }

            if (string.IsNullOrEmpty(MessageID))
            {
                return false;
            }

            if (MessageTimestamp <= 0)
            {
                return false;
            }

            if (Body.SafeLength() > Conversation.MaxMessageLength)
            {
                return false;
            }

            return true;
        }
    }
}