﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Friends.WebService.Requests
{
    public class ConversationHistoryRequest : BaseRequestContract
    {
        public int FriendID
        {
            get;
            set;
        }

        public Guid GroupID
        {
            get;
            set;
        }

        public DateTime StartDate { get; set; }

        public DateTime EndDate { get; set; }
        
        public override bool Validate()
        {
            if (FriendID <= 0 && GroupID == Guid.Empty)
            {
                _validationMessage = "No friend or group specified";
                return false;
            }
            
            return true;
        }
    }
}