﻿using System;
using Curse.Extensions;
using Curse.Friends.Data;

namespace Curse.Friends.WebService.Requests
{

    public class ConversationRenameAttachmentRequest : BaseRequestContract
    {
        public string ConversationID { get; set; }
        public string MessageID { get; set; }
        public long MessageTimestamp { get; set; }
        public string AttachmentID { get; set; }
        public string Title { get; set; }
        
        public override bool Validate()
        {
            if (string.IsNullOrEmpty(ConversationID))
            {
                return false;
            }

            if (string.IsNullOrEmpty(AttachmentID))
            {
                return false;
            }

            if (string.IsNullOrEmpty(MessageID))
            {
                return false;
            }

            if (MessageTimestamp <= 0)
            {
                return false;
            }

            if (Title.SafeLength() > Attachment.MaxTitleLength)
            {
                return false;
            }

            return true;
        }
    }
}