﻿using System;


namespace Curse.Friends.WebService.Requests
{
    public class CreateGroupInviteRequest : BaseRequestContract
    {
        public Guid GroupID { get; set; }

        public bool AutoRemoveMembers { get; set; }

        public TimeSpan? Lifespan { get; set; }

        public override bool Validate()
        {
            if (GroupID == Guid.Empty)
            {
                _validationMessage = "group was not specified.";
                return false;
            }

            if (Lifespan.HasValue && Lifespan.Value < TimeSpan.FromHours(1))
            {
                _validationMessage = "lifespan specified is too short.";
                return false;
            }

            return true;
        }

    }
}