﻿using System.Collections.Generic;
using Curse.Extensions;
using Curse.Friends.Data;

namespace Curse.Friends.WebService.Requests
{
    public class CreateGroupRequest : BaseRequestContract
    {
        public HashSet<int> RecipientsUserIDs
        {
            get;
            set;
        }

        public string Title
        {
            get;
            set;
        }

        public override bool Validate()
        {
            if (Title.SafeLength() > Group.TitleMaxLength)
            {
                _validationMessage = "Title is too long!";
                return false;
            }

            //If there are many receipients
            if (RecipientsUserIDs == null || RecipientsUserIDs.Count == 0 || RecipientsUserIDs.Count > 100)
            {
                _validationMessage = "No recipients or too many recipients!";
                return false;
            }

            return true;
        }
    }
}