﻿using System;
using Curse.Friends.Enums;
using Curse.Extensions;
using Curse.Friends.Data;

namespace Curse.Friends.WebService.Requests
{
    public class CreateGroupRoleRequest : BaseRequestContract
    {
        public Guid GroupID { get; set; }                
        public string Name { get; set; }
        public int VanityColor { get; set;}        
        public bool HasVanityBadge { get; set; }
        public GroupPermissions Permissions { get; set; }

        public override bool Validate()
        {
            if (GroupID == Guid.Empty)
            {
                _validationMessage = "Group ID is null or empty";
                return false;
            }

            if (VanityColor < 0)
            {
                _validationMessage = "Vanity color must be 0 or lower.";
                return false;
            }

            if (Name.SafeLength() < 1 || Name.SafeLength() > GroupRole.NameMaxLength)
            {
                _validationMessage = "Role name cannot be longer than " + GroupRole.NameMaxLength + " characters!";
                return false;
            }
            
            return true;
        }
    }
}