﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Friends.Data;
using Curse.Friends.Enums;

namespace Curse.Friends.WebService.Requests
{
    public class SyncedStreamInfo
    {
        public string ExternalAccountID { get; set; }

        public ExternalAccountType Type { get; set; }

        public bool SyncRoles { get; set; }
    }

    public class CreateStreamerCommunityGroupRequest : BaseRequestContract
    {
        public SyncedStreamInfo[] SyncedStreams { get; set; }

        public override bool Validate()
        {
            return SyncedStreams != null && SyncedStreams.Length > 0 && SyncedStreams.Length < 10;
        }
    }
}