﻿using Curse.Friends.NotificationContracts;
using Curse.Friends.Data;

namespace Curse.Friends.WebService.Requests
{

    public class FriendHintRequest : BaseRequestContract
    {
        
        public FriendHintNotification Identity
        {
            get;
            set;
        }        

        public override bool Validate()
        {
            var hint = FriendHint.FromLegacyNotification(Identity);
            string reason;
            if (!hint.Validate(out reason))
            {
                _validationMessage = reason;
                return false;
            }

            return true;
        }
    }
}