﻿using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Logging;

namespace Curse.Friends.WebService.Requests
{
    public class FriendListSearchRequest : BaseRequestContract
    {
        public FriendHint Identity
        {
            get;
            set;
        }

        public FriendHint[] FriendsList
        {
            get;
            set;
        }

        public override bool Validate()
        {
            string validationReason;

            if (!Identity.Validate(out validationReason))
            {
                _validationMessage = "Invalid identity: " + validationReason;
                return false;
            }

            if (Identity.Status == FriendHintStatus.Deleted)
            {
                return false;
            }

            if (FriendsList == null)
            {
                _validationMessage = "The friends list is null";
                return false;
            }

            if (FriendsList.Length == 0)
            {
                _validationMessage = "The friends list is empty";
                return false;
            }

            if (FriendsList.Length > 2000)
            {
                _validationMessage = "The friends list must be between 1 and 2000 items long. List count: " + FriendsList.Length;
                Logger.Info("[FriendListSearch] User submitted a friends list that is too large to process", new { Identity, FriendsListLength = FriendsList.Length });
                return false;
            }

            return true;
        }
    }
}