﻿using Curse.Friends.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Friends.WebService.Requests
{


    public class FriendSearchRequest : BaseRequestContract
    {

        public string QueryString
        {
            get;
            set;
        }

        public override bool Validate()
        {

            if (string.IsNullOrEmpty(QueryString) || QueryString.Length < 2 || QueryString.Length > 30)
            {
                _validationMessage = "Query string must be between 2 and 30 characters long";
                return false;
            }

            return true;
        }
    }
}