﻿using System;
using Curse.Extensions;

namespace Curse.Friends.WebService.Requests
{
    public class GetVoiceSessionAccessTokenRequest : BaseRequestContract
    {
        public string InviteCode { get; set; }

        public string ClientVersion { get; set; }

        public override bool Validate()
        {
            // TODO: Use a const for this length
            if (InviteCode.SafeLength() > 10)
            {
                _validationMessage = "Invite code is too long.";
                return false;
            }

            Version throwaway;
            if (!Version.TryParse(ClientVersion, out throwaway))
            {
                _validationMessage = "Client Version is invalid.";
                return false;
            }

            return true;
        }
    }
}