﻿using System;
using System.Collections.Generic;
using Curse.Friends.Enums;

namespace Curse.Friends.WebService.Requests
{   
    /// <summary>
    /// Coordinates changes from a voice host to the group, and notifies all members
    /// </summary>
    public class GroupVoiceSessionChangedRequest : BaseRequestContract
    {
        public string ApiKey { get; set; }

        public Guid GroupID { get; set; }

        public GroupChangeType Type { get; set; }

        public HashSet<int> UsersIDs { get; set; }

        public string Code { get; set;  }

        public override bool Validate()
        {
            return true;
        }
    }
}