﻿using System;

namespace Curse.Friends.WebService.Requests
{
    /// <summary>
    /// Request send from client to webserver to leave a group with GroupID
    /// </summary>
    public class LeaveGroupRequest : BaseRequestContract
    {
        public Guid GroupID
        {
            get; set;
        }

        public override bool Validate()
        {
            if (GroupID == Guid.Empty)
            {
                _validationMessage = "group was not specified.";
                return false;
            }
            return true;
        }
    }
}