﻿using System;
using System.Collections.Generic;
using Curse.Friends.Enums;
using Curse.Extensions;
using Curse.Friends.Data;

namespace Curse.Friends.WebService.Requests
{
    public class ModifyGroupRoleRequest : BaseRequestContract
    {
        public Guid RootGroupID { get; set; }
        public Guid AffectedGroupID { get; set; }
        public int RoleID { get; set; }
        public string Name { get; set; }     
        public int VanityColor { get; set;}        
        public bool HasVanityBadge { get; set; }
        public Dictionary<GroupPermissions, GroupPermissionState> Permissions { get; set; }

        public override bool Validate()
        {
            if (RootGroupID == Guid.Empty)
            {
                _validationMessage = "Group ID is null or empty";
                return false;
            }


            if (VanityColor < 0)
            {
                _validationMessage = "Vanity color cannot be 0";
                return false;
            }

            if (Name.SafeLength() < 1 || Name.SafeLength() > GroupRole.NameMaxLength)
            {
                _validationMessage = "Role name cannot be longer than " + GroupRole.NameMaxLength + " characters!";
                return false;
            }

            if (Permissions != null && Permissions.Count > GroupRole.MaxPermissionCount)
            {
                _validationMessage = "Permissions cannot surpass the max number: " + GroupRole.MaxPermissionCount;
                return false;
            }

            return true;
        }
    }
}