﻿using System;

namespace Curse.Friends.WebService.Requests
{
    public class PlaceUserInPromoGroupRequest : BaseRequestContract
    {
        public string ApiKey { get; set; }

        // Promo info
        public Guid PromoID { get; set; }
        
        // User Registration Info
        public int UserID { get; set; }
        public string Username { get; set; }
        public string Email { get; set; }

        public override bool Validate()
        {
            var valid = true;
            
            if (PromoID == Guid.Empty)
            {
                valid = false;
            }
            else if (string.IsNullOrWhiteSpace(ApiKey))
            {
                valid = false;
            }
            else if (UserID < 1 ||string.IsNullOrEmpty(Username))
            {
                valid = false;
            }
            else if (string.IsNullOrEmpty(Email))
            {
                valid = false;
            }

            return valid;
        }
    }
}