﻿using System.Linq;
using Curse.Extensions;
using Curse.Friends.Data;

namespace Curse.Friends.WebService.Requests
{
    public class ProvisionGroupPromoRequest : BaseRequestContract
    {
        public string ApiKey { get; set; }
        
        /// <summary>
        /// The user that will be the owner of the group
        /// </summary>
        public int OwnerUserID { get; set; }

        /// <summary>
        /// The avatar to be used for the groups
        /// </summary>
        public string AvatarUrl { get; set; }

        /// <summary>
        /// The title of the groups to be created
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// An optional array of moderator user IDs
        /// </summary>
        public int[] ModeratorUserIDs { get; set; }

        /// <summary>
        /// How many to provision
        /// </summary>
        public int Count { get; set; }

        public override bool Validate()
        {
            if (OwnerUserID < 1)
            {
                return false;
            }

            if (Title == null || Title.SafeLength() > Group.TitleMaxLength)
            {
                return false;
            }

            if (AvatarUrl == null || AvatarUrl.SafeLength() > Group.AvatarMaxLength)
            {
                return false;
            }

            if (ModeratorUserIDs != null && ModeratorUserIDs.Length > 100)
            {                
                return false;
            }

            return true;
        }
    }
}