﻿using Curse.Friends.Enums;
using System;

namespace Curse.Friends.WebService.Requests
{
    public class RegisterSelfRequest : BaseRequestContract
    {
        public Guid MachineKey
        {
            get;
            set;
        }

        public UserConnectionStatus Status
        {
            get;
            set;
        }

        public DevicePlatform Platform { get; set; }

        /// <summary>
        /// Mobile device token (Apple or Android)
        /// </summary>
        public string DeviceID { get; set; }

        /// <summary>
        /// Apple-only device token for PushKit call notifications.
        /// </summary>
        public string PushKitToken { get; set; }

        public override bool Validate()
        {
            if(MachineKey == null || MachineKey == Guid.Empty)
            {
                _validationMessage = "MachineKey must be a valid Guid";
                return false;
            }
            
            return true;
        }
    }
}