﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Friends.WebService.Requests
{
    public class RemoveUsersFromGroupRequest : BaseRequestContract
    {
        public Guid GroupID { get; set; }

        public HashSet<int> UserIDs
        {
            get;
            set;
        }
        public override bool Validate()
        {
            if (GroupID == Guid.Empty)
            {
                _validationMessage = "Group is null";
                return false;
            }

            if (UserIDs == null)
            {
                _validationMessage = "Invalid recipients";
                return false;
            }

            if (UserIDs.Count > 100)
            {
                _validationMessage = "Too many recipients!";
                return false;
            }
            return true;
        }

    }
}