﻿using Curse.Friends.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Friends.WebService.Requests
{
    public class RenameFriendRequest : BaseRequestContract
    {
        public int FriendID
        {
            get;
            set;
        }

        public string Nickname
        {
            get;
            set;
        }

        public override bool Validate()
        {
            if (FriendID <= 0)
            {
                _validationMessage = "Invalid FriendID";
                return false;
            }

            if (string.IsNullOrWhiteSpace(Nickname) || Nickname.Length > Friendship.OtherUserNicknameMaxLength)
            {
                _validationMessage = "Nickname must be supplied, and less than " + Friendship.OtherUserNicknameMaxLength + " characters.";
                return false;
            }

            return true;
        }

    }
}