﻿using System;

namespace Curse.Friends.WebService.Requests
{
    public class RespondToCallRequest : BaseRequestContract
    {
        public string InviteUrl { get; set; }
        public Guid? GroupID { get; set; }
        public int? FriendID { get; set; }

        /// <summary>
        /// True means accept, False means decline
        /// </summary>
        public bool Accepted { get; set; }

        public override bool Validate()
        {
            if (GroupID.HasValue && FriendID.HasValue)
            {
                _validationMessage = "Both a Group ID and a Friend ID cannot be specified at the same time.";
                return false;
            }
            if (!GroupID.HasValue && !FriendID.HasValue)
            {
                _validationMessage = "Either a Group ID or a Friend ID must be specified.";
                return false;
            }
            if (InviteUrl == null)
            {
                _validationMessage = "The Invite URL must be specified.";
                return false;
            }

            return true;
        }
    }
}