﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Friends.WebService.Requests
{
    public class UnlockCallRequest : BaseRequestContract
    {
        public string CallCode { get; set; }

        public int? FriendToAdd { get; set; }

        public override bool Validate()
        {
            if (CallCode == null)
            {
                _validationMessage = "Call code was not specified.";
                return false;
            }
            if (FriendToAdd != null && FriendToAdd <= 0)
            {
                _validationMessage = "Specified friend is invalid.";
                return false;
            }

            return true;
        }
    }
}