﻿using System;

namespace Curse.Friends.WebService.Requests
{
    public class UnregisterEndpointRequest : BaseRequestContract
    {
        public Guid MachineKey
        {
            get;
            set;
        }

        public string DeviceID { get; set; }

        public override bool Validate()
        {
            if(MachineKey == null || MachineKey == Guid.Empty)
            {
                _validationMessage = "MachineKey must be a valid Guid";
                return false;
            }

            if (string.IsNullOrEmpty(DeviceID))
            {
                _validationMessage = "DeviceID must be supplied";
                return false;
            }
            
            return true;
        }
    }
}