﻿using System;

namespace Curse.Friends.WebService.Requests
{
    public class UpdateDeviceTokensRequest : BaseRequestContract
    {
        public Guid MachineKey { get; set; }

        public string DeviceID { get; set; }
        
        public string PushKitID { get; set; }

        public override bool Validate()
        {
            return MachineKey != Guid.Empty && !string.IsNullOrWhiteSpace(DeviceID) && (PushKitID == null || !string.IsNullOrWhiteSpace(PushKitID));
        }
    }
}