﻿using Curse.CloudSearch;
using Curse.Friends.Data.Search;

namespace Curse.Friends.WebService.Responses
{

    public enum FriendSearchStatus
    {
        Unknown,
        Successful,
        Error,
        Invalid
    }

    public class FriendSearchResponse
    {
        public CloudSearchResult<CharacterSearchModel>[] CharacterMatches { get; set; }
        public CloudSearchResult<EmailSearchModel>[] EmailMatches { get; set; }
        public CloudSearchResult<UsernameSearchModel>[] UserMatches { get; set; }
        public CloudSearchResult<PlatformSearchModel>[] PlatformMatches { get; set; }

        public int ElapsedMilliseconds { get; set; }

        public void AddSearchTime(int ms)
        {
            ElapsedMilliseconds += ms;
        }

        public FriendSearchResponse()
        {
            CharacterMatches = CloudSearchResult<CharacterSearchModel>.EmptyList;
            EmailMatches = CloudSearchResult<EmailSearchModel>.EmptyList;
            UserMatches = CloudSearchResult<UsernameSearchModel>.EmptyList;
        }

        public FriendSearchStatus Status
        {
            get;
            set;
        }

    }
}