﻿using System;
using System.ServiceModel;
using Curse.Friends.Configuration;
using Curse.Friends.Data;
using Curse.Friends.Data.Queues;
using Curse.Friends.Enums;
using Curse.Friends.WebService.Requests;
using Curse.Logging;

namespace Curse.Friends.WebService
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the class name "VoiceCallbackService" in code, svc and config file together.
    // NOTE: In order to launch WCF Test Client for testing this service, please select VoiceCallbackService.svc or VoiceCallbackService.svc.cs at the Solution Explorer and start debugging.
    [ServiceBehavior(Namespace = "http://friends.cursevoice.com/", AddressFilterMode = AddressFilterMode.Any, ConcurrencyMode = ConcurrencyMode.Multiple, InstanceContextMode = InstanceContextMode.PerSession)]
    public class VoiceCallbackService : IVoiceCallbackService
    {        
        public void GroupVoiceSessionChanged(GroupVoiceSessionChangedRequest request)
        {
            try
            {
                if (request.ApiKey != FriendsServiceConfiguration.Instance.CentralServiceApiKey)
                {
                    return;
                }

                var group = Group.GetLocal(request.GroupID);

                if (group == null)
                {
                    return;
                }

                if (request.Type == GroupChangeType.VoiceSessionStarted)
                {
                    group.VoiceSessionCode = request.Code;
                    group.Update(p => p.VoiceSessionCode);
                }
                else if (request.Type == GroupChangeType.VoiceSessionEnded)
                {
                    if (group.VoiceSessionCode == request.Code)
                    {
                        group.VoiceSessionCode = string.Empty; // Temp fix
                        group.Update(p => p.VoiceSessionCode);
                    }
                }

                GroupChangeCordinator.VoiceSessionChanged(group, request.UsersIDs, request.Code, request.Type);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to process a voice callback for group " + request.GroupID, new {request.Type, request.Code});
            }
        }
    }
}
