﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Web;
using Curse.Friends.Data;
using Curse.Logging;
using Newtonsoft.Json;

namespace Curse.Friends.WebService
{
    public static class WebRequestHelper
    {
        public static TResponse SendRequest<TResponse>(string method, string url, string authToken, object content)
        {
            var req = WebRequest.CreateHttp(url);
            req.Method = method;
            req.Accept = "application/json";
            req.Headers.Add("X-Auth-Token", authToken);

            var bytes = Encoding.UTF8.GetBytes(JsonConvert.SerializeObject(content??""));
            req.ContentType = "application/json";
            req.ContentLength = bytes.Length;
            using (var requestStream = req.GetRequestStream())
            {
                requestStream.Write(bytes, 0, bytes.Length);
            }

            using (var response = req.GetResponse())
            {

                var responseStream = response.GetResponseStream();
                if (responseStream != null)
                {
                    using (var ms = new MemoryStream())
                    {
                        responseStream.CopyTo(ms);
                        var str = Encoding.UTF8.GetString(ms.ToArray());
                        return JsonConvert.DeserializeObject<TResponse>(str);
                    }
                }
            }

            return default(TResponse);
        }
    }
}